//----------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "USBDetect.h"
#pragma package(smart_init)
//---------------------------------------------------------
static inline void ValidCtrCheck(TUSBDetect *)
{
        new TUSBDetect(NULL);
}
//---------------------------------------------------------
__fastcall TUSBDetect::TUSBDetect(TComponent* Owner)
        : TComponent(Owner)
{
  FWindowHandle = AllocateHWnd(WindowProc);
  USBDeviceNotify();
}
//---------------------------------------------------------
namespace Usbdetect
{
   void __fastcall PACKAGE Register() {
         TComponentClass classes[1] = {__classid(TUSBDetect)};
         RegisterComponents("Samples", classes, 0);
   }
}
//---------------------------------------------------------
__fastcall TUSBDetect::~TUSBDetect()
{
  DeallocateHWnd(FWindowHandle);
}
//---------------------------------------------------------
void __fastcall TUSBDetect::WindowProc(TMessage &msg)
{
  if (msg.Msg = WM_DEVICECHANGE) {
    try {
     deviceAttachDetach(msg);
    }
    catch(...) {
      Application->HandleException(this);
    }
   }
   else
     msg.Result = DefWindowProc(FWindowHandle, msg.Msg,
                                msg.WParam, msg.LParam);
};
//---------------------------------------------------------
void __fastcall TUSBDetect::deviceAttachDetach(TMessage &msg)
{
  UINT devType;
  PDEV_BROADCAST_HDR hdr;
  if ((msg.WParam==DBT_DEVICEARRIVAL) ||
     (msg.WParam==DBT_DEVICEREMOVECOMPLETE)) {
     hdr = (PDEV_BROADCAST_HDR)msg.LParam;
     devType = hdr->dbch_devicetype;
     if (devType==DBT_DEVTYP_DEVICEINTERFACE) {// urzdzenie USB
       if (msg.WParam==DBT_DEVICEARRIVAL) {
         if (FUSBAttach)
           FUSBAttach(this);
       }
       else {
        if (FUSBDetach)
          FUSBDetach(this);
       };
     };
  };
};
//---------------------------------------------------------
bool __fastcall TUSBDetect::USBDeviceNotify()
{
  void *result;
  DEV_BROADCAST_DEVICEINTERFACE NotificationFilter;
  ZeroMemory(&NotificationFilter, sizeof(NotificationFilter));
  NotificationFilter.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
  NotificationFilter.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
  NotificationFilter.dbcc_classguid = GUID_DEVINTERFACE_USB_DEVICE;
  result = RegisterDeviceNotification(FWindowHandle, &NotificationFilter,
                                             DEVICE_NOTIFY_WINDOW_HANDLE);
  if(!result)
    return false;
  return true;
}
//---------------------------------------------------------


